function [num] = dt_str2num(str)
%[num] = dt_str2num(str)
%convert the given data type name to corresponding number 
%according to Analyze data format.
%Input:
% str: data type name,Currently supported values are 
%      'DT_UNKNOWN','DT_BINARY','uchar','int16','int32',
%      'float','complex','double','DT_RGB' and 'DT_ALL'.
%Output:
%num: a integer. 
%
%20040318, jdlee
%

switch str,
case 'DT_UNKNOWN', num = 0;
case 'DT_BINARY',  num = 1;
case 'uchar',      num = 2;
case 'int16',      num = 4;
case 'int32',      num = 8;
case 'float',      num = 16;
case 'complex',    num = 32;
case 'double',     num = 64;
case 'DT_RGB',     num = 128;
case 'DT_ALL',     num = 255;
otherwise, 
    error('unknown input string');
end

return